/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.images.VWImageLoader;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class VWMappingLists {
    private Hashtable m_iconLookupTable = null;
    private String[] m_itemNames = null;
    private Hashtable m_itemLookupTable = null;

    protected VWMappingLists() {
        this.buildIconLookupLists();
        this.buildItemLookupList();
    }

    public String[] getItemNames() {
        return this.m_itemNames;
    }

    public ImageIcon lookupIcon(String localizedName) {
        Object obj;
        if (this.m_iconLookupTable != null && (obj = this.m_iconLookupTable.get(localizedName)) != null) {
            return (ImageIcon)obj;
        }
        return null;
    }

    public String lookupItem(String uniqueName) {
        Object obj;
        if (this.m_itemLookupTable != null && (obj = this.m_itemLookupTable.get(uniqueName)) != null) {
            return (String)obj;
        }
        return null;
    }

    private void buildIconLookupLists() {
        try {
            this.m_iconLookupTable = new Hashtable();
            this.m_iconLookupTable.put(VWResource.s_start, VWImageLoader.createImageIcon("startStep16.gif"));
            this.m_iconLookupTable.put(VWResource.s_component, VWImageLoader.createImageIcon("componentStep16.gif"));
            this.m_iconLookupTable.put(VWResource.s_general, VWImageLoader.createImageIcon("generalStep16.gif"));
            this.m_iconLookupTable.put(VWResource.s_system, VWImageLoader.createImageIcon("systemStep16.gif"));
            this.m_iconLookupTable.put(VWResource.s_submap, VWImageLoader.createImageIcon("submapStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(27), VWImageLoader.createImageIcon("beginCheckpointStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(28), VWImageLoader.createImageIcon("endCheckpointStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(29), VWImageLoader.createImageIcon("rollbackCheckpointStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(0), VWImageLoader.createImageIcon("assignStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(6), VWImageLoader.createImageIcon("createWorkflowStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(37), VWImageLoader.createImageIcon("dbExecuteStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(7), VWImageLoader.createImageIcon("delayStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(38), VWImageLoader.createImageIcon("logStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(14), VWImageLoader.createImageIcon("returnStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(17), VWImageLoader.createImageIcon("terminateBranchStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(42), VWImageLoader.createImageIcon("terminateProcessStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(19), VWImageLoader.createImageIcon("waitForConditionStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(1), VWImageLoader.createImageIcon("beginTimerStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(8), VWImageLoader.createImageIcon("endAllTimersStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(9), VWImageLoader.createImageIcon("endTimerStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(13), VWImageLoader.createImageIcon("resumeTimerStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(16), VWImageLoader.createImageIcon("suspendTimerStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(39), VWImageLoader.createImageIcon("invokeStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(40), VWImageLoader.createImageIcon("receiveStep16.gif"));
            this.m_iconLookupTable.put(VWFunctionStrings.getLocalizedString(41), VWImageLoader.createImageIcon("replyStep16.gif"));
            this.m_iconLookupTable.put(VWResource.s_route, VWImageLoader.createImageIcon("route16.gif"));
            this.m_iconLookupTable.put(VWResource.s_association, VWImageLoader.createImageIcon("association16.gif"));
            this.m_iconLookupTable.put(VWResource.s_textAnnotation, VWImageLoader.createImageIcon("textAnnotation16.gif"));
            this.m_iconLookupTable.put(VWResource.s_workflowProcess, VWImageLoader.createImageIcon("workflow16.gif"));
            this.m_iconLookupTable.put(VWResource.s_attachment, VWImageLoader.createImageIcon("attachment16.gif"));
            this.m_iconLookupTable.put(VWResource.s_dataField, VWImageLoader.createImageIcon("dataField16.gif"));
            this.m_iconLookupTable.put(VWResource.s_workflowGroup, VWImageLoader.createImageIcon("workflowGroup16.gif"));
            this.m_iconLookupTable.put(VWResource.s_xmlDataField, VWImageLoader.createImageIcon("xmlField16.gif"));
            int nIndex = 0;
            this.m_itemNames = new String[this.m_iconLookupTable.size()];
            Enumeration myEnum = this.m_iconLookupTable.keys();
            while (myEnum.hasMoreElements()) {
                this.m_itemNames[nIndex++] = (String)myEnum.nextElement();
            }
            VWQubbleSort.sort(this.m_itemNames);
            this.m_iconLookupTable.put(VWResource.s_unmapped, VWImageLoader.createImageIcon("blank16.gif"));
            this.m_iconLookupTable.put(VWResource.s_nothing, VWImageLoader.createImageIcon("nothing16.gif"));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void buildItemLookupList() {
        try {
            this.m_itemLookupTable = new Hashtable();
            this.m_itemLookupTable.put("Start", VWResource.s_start);
            this.m_itemLookupTable.put("Component", VWResource.s_component);
            this.m_itemLookupTable.put("General", VWResource.s_general);
            this.m_itemLookupTable.put("System", VWResource.s_system);
            this.m_itemLookupTable.put("Submap", VWResource.s_submap);
            this.m_itemLookupTable.put("Checkpoint - BeginCheckpoint", VWFunctionStrings.getLocalizedString(27));
            this.m_itemLookupTable.put("Checkpoint - EndCheckpoint", VWFunctionStrings.getLocalizedString(28));
            this.m_itemLookupTable.put("Checkpoint - RollbackCheckpoint", VWFunctionStrings.getLocalizedString(29));
            this.m_itemLookupTable.put("Assign", VWFunctionStrings.getLocalizedString(0));
            this.m_itemLookupTable.put("Create", VWFunctionStrings.getLocalizedString(6));
            this.m_itemLookupTable.put("DbExecute", VWFunctionStrings.getLocalizedString(37));
            this.m_itemLookupTable.put("Delay", VWFunctionStrings.getLocalizedString(7));
            this.m_itemLookupTable.put("Log", VWFunctionStrings.getLocalizedString(38));
            this.m_itemLookupTable.put("Return", VWFunctionStrings.getLocalizedString(14));
            this.m_itemLookupTable.put("TerminateBranch", VWFunctionStrings.getLocalizedString(17));
            this.m_itemLookupTable.put("TerminateProcess", VWFunctionStrings.getLocalizedString(42));
            this.m_itemLookupTable.put("WaitForCondition", VWFunctionStrings.getLocalizedString(19));
            this.m_itemLookupTable.put("Timer - BeginTimer", VWFunctionStrings.getLocalizedString(1));
            this.m_itemLookupTable.put("Timer - EndAllTimers", VWFunctionStrings.getLocalizedString(8));
            this.m_itemLookupTable.put("Timer - EndTimer", VWFunctionStrings.getLocalizedString(9));
            this.m_itemLookupTable.put("Timer - ResumeTimer", VWFunctionStrings.getLocalizedString(13));
            this.m_itemLookupTable.put("Timer - SuspendTimer", VWFunctionStrings.getLocalizedString(16));
            this.m_itemLookupTable.put("Invoke", VWFunctionStrings.getLocalizedString(39));
            this.m_itemLookupTable.put("Receive", VWFunctionStrings.getLocalizedString(40));
            this.m_itemLookupTable.put("Reply", VWFunctionStrings.getLocalizedString(41));
            this.m_itemLookupTable.put("Route", VWResource.s_route);
            this.m_itemLookupTable.put("Association", VWResource.s_association);
            this.m_itemLookupTable.put("Text Annotation", VWResource.s_textAnnotation);
            this.m_itemLookupTable.put("Workflow Process", VWResource.s_workflowProcess);
            this.m_itemLookupTable.put("Attachment", VWResource.s_attachment);
            this.m_itemLookupTable.put("Data Field", VWResource.s_dataField);
            this.m_itemLookupTable.put("Workflow Group", VWResource.s_workflowGroup);
            this.m_itemLookupTable.put("XML Data Field", VWResource.s_xmlDataField);
            this.m_itemLookupTable.put("Nothing", VWResource.s_nothing);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

